<?php
/* --------------------------------------------------------------
 FooterBadgesLoader.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Google\Admin\Plugin;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Admin\Layout\Smarty\Loaders\AbstractFooterBadgeLoader;
use Gambio\Core\Language\TextManager;

/**
 * Class FooterBadgesLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class GoogleFooterBadgeLoader extends AbstractFooterBadgeLoader
{
    /**
     * @var TextManager
     */
    private $textManager;
    
    /**
     * @var Connection
     */
    private $connection;
    
    /**
     * @var Url
     */
    private $url;
    
    /**
     * @var Path
     */
    private $path;
    
    
    /**
     * FooterBadgesLoader constructor.
     *
     * @param Connection  $connection
     * @param TextManager $textManager
     * @param Url         $url
     * @param Path        $path
     */
    public function __construct(Connection $connection, TextManager $textManager, Url $url, Path $path)
    {
        $this->connection  = $connection;
        $this->textManager = $textManager;
        $this->url         = $url;
        $this->path        = $path;
    }
    
    
    /**
     * @inheritDoc
     */
    protected function dataText(bool $isConnected): string
    {
        $phrase = $isConnected ? 'TEXT_GOOGLE_ADWORDS_CONNECTED' : 'TEXT_GOOGLE_ADWORDS_DISCONNECTED';
        
        return $this->textManager->getPhraseText($phrase, 'admin_general');
    }
    
    
    /**
     * @inheritDoc
     */
    protected function jsExtenderSrc(): string
    {
        $extension = file_exists("{$this->path->base()}/.dev-environment") ? '.min.js' : '.js';
        $filepath  = 'GXModules/Gambio/GoogleOAuth/Build/Admin/Javascript/extenders/footer_google_adwords_state';
        
        return "{$this->url->base()}/{$filepath}{$extension}";
    }
    
    
    /**
     * @inheritDoc
     */
    protected function isConnected(): bool
    {
        $qb = $this->connection->createQueryBuilder();
        
        $optionEqConnectionStatus = "{$this->connection->quoteIdentifier('option')} = {$qb->createNamedParameter('connection-status')}";
        $scopeEqGeneral           = "{$this->connection->quoteIdentifier('scope')} = {$qb->createNamedParameter('general')}";
        
        $result = $qb->select($this->connection->quoteIdentifier('value'))
            ->from('google_configurations')
            ->where($optionEqConnectionStatus)
            ->andWhere($scopeEqGeneral)
            ->execute()
            ->fetch();
        
        if (!$result || !array_key_exists('value', $result)) {
            return false;
        }
        $parsedResult = json_decode($result['value'], true);
        
        return !array_key_exists('value', $parsedResult) ? false : (bool)$parsedResult['value'];
    }
}